// This project is released under the GPL Licence

/*****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <math.h>

/*****************************************************************************/

#include "ladspa.h"

/*****************************************************************************/

/* The port numbers for the plugin: */

#define PXU_CONTROL1 0
#define PXU_CONTROL2 1
#define PXU_CONTROL3 2
#define PXU_CONTROL4 3
#define PXU_CONTROL5 4
#define PXU_CONTROL6 5
#define PXU_CONTROL7 6
#define PXU_CONTROL8 7
#define PXU_CONTROL9 8
#define PXU_CONTROL10 9
#define PXU_CONTROL11 10
#define PXU_CONTROL12 11
#define PXU_CONTROL13 12
#define PXU_CONTROL14 13
#define PXU_CONTROL15 14
#define PXU_CONTROL16 15
#define PXU_CONTROL17 16
#define PXU_CONTROL18 17
#define PXU_CONTROL19 18
#define PXU_CONTROL20 19

#define PXU_INPUT1  20
#define PXU_OUTPUT1 21
#define PXU_INPUT2  22
#define PXU_OUTPUT2 23

/*****************************************************************************/

/* The structure used to hold port connection information and state
   (actually gain controls require no further state). */

typedef struct {

  /* Ports:
     ------ */
  LADSPA_Data * m_pfControlValue1;
  LADSPA_Data * m_pfControlValue2;
  LADSPA_Data * m_pfControlValue3;
  LADSPA_Data * m_pfControlValue4;
  LADSPA_Data * m_pfControlValue5;
  LADSPA_Data * m_pfControlValue6;
  LADSPA_Data * m_pfControlValue7;
  LADSPA_Data * m_pfControlValue8;
  LADSPA_Data * m_pfControlValue9;
  LADSPA_Data * m_pfControlValue10;
  LADSPA_Data * m_pfControlValue11;
  LADSPA_Data * m_pfControlValue12;
  LADSPA_Data * m_pfControlValue13;
  LADSPA_Data * m_pfControlValue14;
  LADSPA_Data * m_pfControlValue15;
  LADSPA_Data * m_pfControlValue16;
  LADSPA_Data * m_pfControlValue17;
  LADSPA_Data * m_pfControlValue18;
  LADSPA_Data * m_pfControlValue19;
  LADSPA_Data * m_pfControlValue20;
  LADSPA_Data * m_pfInputBuffer1;
  LADSPA_Data * m_pfOutputBuffer1;
  LADSPA_Data * m_pfInputBuffer2;  /* (Not used for mono) */
  LADSPA_Data * m_pfOutputBuffer2; /* (Not used for mono) */


// avoiding pointer variables for the multiband. That means only one instance can be used.

} Pxu;


/*****************************************************************************/

LADSPA_Handle
instantiatePxu(const LADSPA_Descriptor * Descriptor,
			   unsigned long             SampleRate) {

  Pxu * psPxu;

  psPxu
    = (Pxu *)malloc(sizeof(Pxu));

  if (psPxu == NULL)
    return NULL;

 	i_bfcn = 0;
	i_cnt = 0;


	b_sensitivity = pow(2,(((1)*-20))/ 6);

int i_cnt2 = 0;
while (i_cnt2 < 4) {
	b_cmpslp[i_cnt2] = -1;
	b_cmpcut[i_cnt2] = -1;
	b_cmpla[i_cnt2] = -1;

	i_optcnt[i_cnt2] = 10001;
	i_h1sortcurr[i_cnt2] = 0;
	b_h1highest[i_cnt2] = 0;
	i_h2sortcurr[i_cnt2] = 0;
	b_h2highest[i_cnt2] = 1;
	b_lenv[i_cnt2] = 1;

	b_gse1buf[i_cnt2] = 1;
	b_gse2buf[i_cnt2] = 1;
	b_gse3buf[i_cnt2] = 1;
	b_gse4buf[i_cnt2] = 1;
	b_gse5buf[i_cnt2] = 1;

	i_cnt = 0;
	while (i_cnt < 1002) {

		b_h1buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg5buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg6buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg7buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg8buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg9buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg10buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg11buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg12buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg13buf[i_cnt2][i_cnt] = b_sensitivity;
		b_avg14buf[i_cnt2][i_cnt] = b_sensitivity;

		b_h2buf[i_cnt2][i_cnt] = 1;
		b_avg1buf[i_cnt2][i_cnt] = 1;
		b_avg2buf[i_cnt2][i_cnt] = 1;
		b_avg3buf[i_cnt2][i_cnt] = 1;
		b_avg4buf[i_cnt2][i_cnt] = 1;

		b_syncbufL[i_cnt2][i_cnt] = 0;
		b_syncbufR[i_cnt2][i_cnt] = 0;

		i_cnt++;
	}
	i_cnt2++;
}

	b_off = 14.430;

	b_flcmp1 = -1;
	b_flcmp2 = -1;
	b_flcmp3 = -1;

  return psPxu;
}


/*****************************************************************************/

/* Connect a port to a data location. */
void
connectPortToPxu(LADSPA_Handle Instance,
		       unsigned long Port,
		       LADSPA_Data * DataLocation) {

  Pxu * psPxu;

  psPxu = (Pxu *)Instance;
  switch (Port) {
  case PXU_CONTROL1:
    psPxu->m_pfControlValue1 = DataLocation;
    break;
  case PXU_CONTROL2:
    psPxu->m_pfControlValue2 = DataLocation;
    break;
  case PXU_CONTROL3:
    psPxu->m_pfControlValue3 = DataLocation;
    break;
  case PXU_CONTROL4:
    psPxu->m_pfControlValue4 = DataLocation;
    break;
  case PXU_CONTROL5:
    psPxu->m_pfControlValue5 = DataLocation;
    break;
  case PXU_CONTROL6:
    psPxu->m_pfControlValue6 = DataLocation;
    break;
  case PXU_CONTROL7:
    psPxu->m_pfControlValue7 = DataLocation;
    break;
  case PXU_CONTROL8:
    psPxu->m_pfControlValue8 = DataLocation;
    break;
  case PXU_CONTROL9:
    psPxu->m_pfControlValue9 = DataLocation;
    break;
  case PXU_CONTROL10:
    psPxu->m_pfControlValue10 = DataLocation;
    break;
  case PXU_CONTROL11:
    psPxu->m_pfControlValue11 = DataLocation;
    break;
  case PXU_CONTROL12:
    psPxu->m_pfControlValue12 = DataLocation;
    break;
  case PXU_CONTROL13:
    psPxu->m_pfControlValue13 = DataLocation;
    break;
  case PXU_CONTROL14:
    psPxu->m_pfControlValue14 = DataLocation;
    break;
  case PXU_CONTROL15:
    psPxu->m_pfControlValue15 = DataLocation;
    break;
  case PXU_CONTROL16:
    psPxu->m_pfControlValue16 = DataLocation;
    break;
  case PXU_CONTROL17:
    psPxu->m_pfControlValue17 = DataLocation;
    break;
  case PXU_CONTROL18:
    psPxu->m_pfControlValue18 = DataLocation;
    break;
  case PXU_CONTROL19:
    psPxu->m_pfControlValue19 = DataLocation;
    break;
  case PXU_CONTROL20:
    psPxu->m_pfControlValue20 = DataLocation;
    break;
  case PXU_INPUT1:
    psPxu->m_pfInputBuffer1 = DataLocation;
    break;
  case PXU_OUTPUT1:
    psPxu->m_pfOutputBuffer1 = DataLocation;
    break;
  case PXU_INPUT2:
    /* (This should only happen for stereo.) */
    psPxu->m_pfInputBuffer2 = DataLocation;
    break;
  case PXU_OUTPUT2:
    /* (This should only happen for stereo.) */
    psPxu->m_pfOutputBuffer2 = DataLocation;
    break;
  }

}

/*****************************************************************************/

void
runMonoPxu(LADSPA_Handle Instance,
		 unsigned long SampleCount) {

  LADSPA_Data * pfInput;
  LADSPA_Data * pfOutput;
  LADSPA_Data fVar1;
  LADSPA_Data fVar2;
  LADSPA_Data fVar3;
  Pxu * psPxu;
  unsigned long lSampleIndex;

  psPxu = (Pxu *)Instance;

  pfInput = psPxu->m_pfInputBuffer1;
  pfOutput = psPxu->m_pfOutputBuffer1;
  fVar1 = *(psPxu->m_pfControlValue1);
  fVar2 = *(psPxu->m_pfControlValue2);
  fVar3 = *(psPxu->m_pfControlValue3);

  for (lSampleIndex = 0; lSampleIndex < SampleCount; lSampleIndex++)
    *(pfOutput++) = *(pfInput++) * fVar1;
}

/*****************************************************************************/

void
runStereoPxu(LADSPA_Handle Instance,
		   unsigned long SampleCount) {

  LADSPA_Data * pfInput1;
  LADSPA_Data * pfInput2;
  LADSPA_Data * pfOutput1;
  LADSPA_Data * pfOutput2;
  LADSPA_Data fvarg0;
  LADSPA_Data fvarg1;
  LADSPA_Data fvarg2;
  LADSPA_Data fvarg3;
  LADSPA_Data fvarg4;
  LADSPA_Data fvarg5;
  LADSPA_Data fvarg6;
  LADSPA_Data fvarg7;
  LADSPA_Data fvarg8;
  LADSPA_Data fvarg9;
  LADSPA_Data fvarg10;
  LADSPA_Data fvarg11;
  LADSPA_Data fvarg12;
  LADSPA_Data fvarg13;
  LADSPA_Data fvarg14;
  LADSPA_Data fvarg15;
  LADSPA_Data fvarg16;
  LADSPA_Data fvarg17;
  LADSPA_Data fvarg18;
  LADSPA_Data fvarg19;

  Pxu * psPxu;
  unsigned long lSampleIndex;

  psPxu = (Pxu *)Instance;

  fvarg0 = *(psPxu->m_pfControlValue1);
  fvarg1= *(psPxu->m_pfControlValue2);
  fvarg2= *(psPxu->m_pfControlValue3);
  fvarg3= *(psPxu->m_pfControlValue4);
  fvarg4= *(psPxu->m_pfControlValue5);
  fvarg5= *(psPxu->m_pfControlValue6);
  fvarg6= *(psPxu->m_pfControlValue7);
  fvarg7= *(psPxu->m_pfControlValue8);
  fvarg8= *(psPxu->m_pfControlValue9);
  fvarg9= *(psPxu->m_pfControlValue10);
  fvarg10= *(psPxu->m_pfControlValue11);
  fvarg11= *(psPxu->m_pfControlValue12);
  fvarg12= *(psPxu->m_pfControlValue13);
  fvarg13= *(psPxu->m_pfControlValue14);
  fvarg14= *(psPxu->m_pfControlValue15); 
  fvarg15= *(psPxu->m_pfControlValue16); 
  fvarg14= *(psPxu->m_pfControlValue17); 
  fvarg17= *(psPxu->m_pfControlValue18); 
  fvarg18= *(psPxu->m_pfControlValue19); 
  fvarg19= *(psPxu->m_pfControlValue20); 

  pfInput1 = psPxu->m_pfInputBuffer1;
  pfInput2 = psPxu->m_pfInputBuffer2;
  pfOutput1 = psPxu->m_pfOutputBuffer1;
  pfOutput2 = psPxu->m_pfOutputBuffer2;

	//m
	int i_b;

	int i_solo = fvarg19 * 5; if (i_solo > 4) {i_solo = 4;}

//
	long double b_of1,b_of2,b_of3,b_of4,b_of5;
	long double b_cErr;
	long double b_cSum;
	long double b_cSumpre;
	long double b_cSub;
	long double b_cIn;
	
	//	int i_optimize = fvarg29*1000;
	int i_optimize = 10001;
//	b_sensitivity = pow(2,(((0.8570)*-1000))/ 6); 
	b_sensitivity = pow(2,(((0.0200)*-1000))/ 6); // fixes denormal "bug".
//	long double b_sensrms = sqrt(b_sensitivity);


	// adjust to samplerate //
//float b_sr = getSampleRate();                   
float b_sr = 44100;
	long double b_srt = b_sr/44100;

	//m
	int i_la[4];
	long double b_la[4];
	int i_htravlensub[4];
	int i_htravlen[4];
	int i_avglen[4];
	int i_avglen2[4];
	long double b_htravlen[4];
	b_la[0] = (((fvarg2 * 180)+20) * b_srt) + 0.5;
	b_la[1] = (((fvarg6 * 180)+20) * b_srt) + 0.5;
	b_la[2] = (((fvarg10* 180)+20) * b_srt) + 0.5;
	b_la[3] = (((fvarg14* 180)+20) * b_srt) + 0.5;
	i_b = 0;
	int i_highla = 0;
	while (i_b < 4) {
		i_la[i_b] = b_la[i_b];
		if (i_highla < i_la[i_b]) {i_highla = i_la[i_b];}
		if (b_la[i_b] != b_cmpla[i_b]) {i_optcnt[i_b] = i_optimize; b_cmpla[i_b] = b_la[i_b];}
		i_htravlensub[i_b] = i_la[i_b];
		i_htravlen[i_b] = i_htravlensub[i_b] + 1;
		i_avglen[i_b] = i_htravlen[i_b];
		i_avglen2[i_b] = ((i_la[i_b] * 2) + 1); 
		b_htravlen[i_b] = i_htravlen[i_b];

		i_b++;
	}
//	setInitialDelay(i_highla); // realtime plugin-delay compensation.

	int i_bufpoint;
	long double b_sub;
	int i_cnt = 0;


/*/
int i_avglen3 = fvarg8 * 100;
long double b_totlen = i_avglen3; 
b_totlen = b_totlen - 1;
b_totlen = b_totlen / 2;
int i_totdel = b_totlen * 4;
int i_totdel0 = i_totdel;
/*/
	// front
	long double b_ingain[4];
	b_ingain[0] = pow(2,(((fvarg0-0.5)*100))/ 6); 
	b_ingain[1] = pow(2,(((fvarg4-0.5)*100))/ 6); 
	b_ingain[2] = pow(2,(((fvarg8-0.5)*100))/ 6); 
	b_ingain[3] = pow(2,(((fvarg12-0.5)*100))/ 6); 
	long double b_thr[4];
	b_thr[0] = pow(2,((((1-fvarg1)-0.5)*100))/ 6); 
	b_thr[1] = pow(2,((((1-fvarg5)-0.5)*100))/ 6); 
	b_thr[2] = pow(2,((((1-fvarg9)-0.5)*100))/ 6); 
	b_thr[3] = pow(2,((((1-fvarg13)-0.5)*100))/ 6); 
	long double b_release[4];
	b_release[0] = (pow(2,(((1-(fvarg3))*-100))/ 6)) / b_srt;  
	b_release[1] = (pow(2,(((1-(fvarg7))*-100))/ 6)) / b_srt;  
	b_release[2] = (pow(2,(((1-(fvarg11))*-100))/ 6)) / b_srt;  
	b_release[3] = (pow(2,(((1-(fvarg15))*-100))/ 6)) / b_srt;  


	long double b_tgcut[4];
	long double b_tgslp[4];
	long double b_tgcut1[4];
	long double b_tgcut2[4];
	long double b_tgcut3[4];
	long double b_tgcut4[4];
	long double b_tgcut5[4];
	long double b_tggain1[4];
	long double b_tggain2[4];
	long double b_tggain3[4];
	long double b_tggain4[4];
	long double b_tggain5[4];

	i_b = 0;
	while (i_b < 4) {
		b_tgcut[i_b] = 0.1640;
		b_tgslp[i_b] = (0.9830*0.0100)+0.9900;
		b_tgcut[i_b] = 1-(b_tgcut[i_b]/b_htravlen[i_b]*50);
		if (b_tgcut[i_b] != b_cmpcut[i_b]) {i_optcnt[i_b] = i_optimize; b_cmpcut[i_b] = b_tgcut[i_b];}
		if (b_tgslp[i_b] != b_cmpslp[i_b]) {i_optcnt[i_b] = i_optimize; b_cmpslp[i_b] = b_tgslp[i_b];}
		b_tgcut1[i_b] = b_tgcut[i_b] * b_tgslp[i_b] * b_tgslp[i_b] * b_tgslp[i_b] * b_tgslp[i_b];
		b_tgcut2[i_b] = b_tgcut[i_b] * b_tgslp[i_b] * b_tgslp[i_b] * b_tgslp[i_b];
		b_tgcut3[i_b] = b_tgcut[i_b] * b_tgslp[i_b] * b_tgslp[i_b];
		b_tgcut4[i_b] = b_tgcut[i_b] * b_tgslp[i_b];
		b_tgcut5[i_b] = b_tgcut[i_b];

		b_tgcut1[i_b] = 1-b_tgcut1[i_b];
		b_tgcut2[i_b] = 1-b_tgcut2[i_b];
		b_tgcut3[i_b] = 1-b_tgcut3[i_b];
		b_tgcut4[i_b] = 1-b_tgcut4[i_b];
		b_tgcut5[i_b] = 1-b_tgcut5[i_b];

		b_tggain1[i_b] = 1;
		b_tggain2[i_b] = -4;
		b_tggain3[i_b] = 6;
		b_tggain4[i_b] = -4;
		b_tggain5[i_b] = 1;

		b_tggain1[i_b] = b_tggain1[i_b] / b_tgcut1[i_b];
		b_tggain2[i_b] = b_tggain2[i_b] / b_tgcut2[i_b];
		b_tggain3[i_b] = b_tggain3[i_b] / b_tgcut3[i_b];
		b_tggain4[i_b] = b_tggain4[i_b] / b_tgcut4[i_b];
		b_tggain5[i_b] = b_tggain5[i_b] / b_tgcut5[i_b];

		b_of1 = b_tggain1[i_b];
		b_of2 = b_tggain2[i_b];
		b_of3 = b_tggain3[i_b];
		b_of4 = b_tggain4[i_b];
		b_of5 = b_tggain5[i_b];

		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
	
		long double b_tgnrm = 1/b_cSum;
	
		b_tggain1[i_b] = b_tggain1[i_b] * b_tgnrm;
		b_tggain2[i_b] = b_tggain2[i_b] * b_tgnrm;
		b_tggain3[i_b] = b_tggain3[i_b] * b_tgnrm;
		b_tggain4[i_b] = b_tggain4[i_b] * b_tgnrm;
		b_tggain5[i_b] = b_tggain5[i_b] * b_tgnrm;

		i_b++;}

	// tweaked for "quiet" psychoacoustic.

//	long double b_tgnrm = 1/(b_tggain1 + b_tggain2 + b_tggain3 + b_tggain4 + b_tggain5);


// Fast Gaussian filter (variable 1th to 9nth order lowpass, minimal phase)
		long double b_gse1gain;
		long double b_gse2gain;
		long double b_gse3gain;
		long double b_gse4gain;
		long double b_gse5gain;

		b_gse1gain = 1;
		b_gse2gain = -4;
		b_gse3gain = 6;
		b_gse4gain = -4;
		b_gse5gain = 1;

		long double b_gse1cut;
		long double b_gse2cut;
		long double b_gse3cut;
		long double b_gse4cut;
		long double b_gse5cut;

		// max saturation of transient, more is unnatural, less is unessecary.
		long double b_gseslope = 1-pow(2,(((0.5770)*-100))/ 6);  // 0.5 = stable.. 
		long double b_gsecut = 1-pow(0.4220,6); //

		b_gse1cut = b_gsecut * b_gseslope * b_gseslope * b_gseslope * b_gseslope;
		b_gse2cut = b_gsecut * b_gseslope * b_gseslope * b_gseslope;
		b_gse3cut = b_gsecut * b_gseslope * b_gseslope;
		b_gse4cut = b_gsecut * b_gseslope;
		b_gse5cut = b_gsecut;

		b_gse1cut = 1-b_gse1cut;
		b_gse2cut = 1-b_gse2cut;
		b_gse3cut = 1-b_gse3cut;
		b_gse4cut = 1-b_gse4cut;
		b_gse5cut = 1-b_gse5cut;

		b_gse1gain = b_gse1gain / b_gse1cut;
		b_gse2gain = b_gse2gain / b_gse2cut;
		b_gse3gain = b_gse3gain / b_gse3cut;
		b_gse4gain = b_gse4gain / b_gse4cut;
		b_gse5gain = b_gse5gain / b_gse5cut;

//		long double b_gsenrm = 1/(
//			 b_gse1gain  
//			+b_gse2gain  
//			+b_gse3gain 
//			+b_gse4gain 
//			+b_gse5gain 
//		);
	b_of1 = b_gse1gain;
	b_of2 = b_gse2gain;
	b_of3 = b_gse3gain;
	b_of4 = b_gse4gain;
	b_of5 = b_gse5gain;

	b_cErr = 0;
	b_cSum = 0;

	b_cIn = b_of1;
	b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
	b_cSum = b_cSum + b_cSub;
	b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
	b_cIn = b_of2;
	b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
	b_cSum = b_cSum + b_cSub;
	b_cErr = (b_cSum-b_cSumpre) - b_cSub;

	b_cIn = b_of3;
	b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
	b_cSum = b_cSum + b_cSub;
	b_cErr = (b_cSum-b_cSumpre) - b_cSub;

	b_cIn = b_of4;
	b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
	b_cSum = b_cSum + b_cSub;
	b_cErr = (b_cSum-b_cSumpre) - b_cSub;

	b_cIn = b_of5;
	b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
	b_cSum = b_cSum + b_cSub;
	b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
	long double b_gsenrm = 1/b_cSum;

		b_gse1gain = b_gse1gain * b_gsenrm;
		b_gse2gain = b_gse2gain * b_gsenrm;
		b_gse3gain = b_gse3gain * b_gsenrm;
		b_gse4gain = b_gse4gain * b_gsenrm;
		b_gse5gain = b_gse5gain * b_gsenrm;

//
/////////
/*/
long double b_spow1 = (fvarg16*10000) + 1;
long double b_spow2 = 1/b_spow1;
b_spow1 = 1/b_spow1; b_spow2 = 1/b_spow2;
long double b_spoff = pow(2,(((fvarg15-0.5)*200))/ 6); 

long double b_spow3 = (fvarg18*10) + 1;
long double b_spoff2 = pow(2,(((fvarg17-0.5)*2000))/ 6); 
/*/


		long double b_rtype = 0.805;
		long double b_discam = 0.3600*0.01;

		long double b_f1;
		long double b_f2;
		long double b_f3;
		long double b_f4;

		// create bandsplit filters.
		int i_flen = 300; // delay = 100;
		int i_createfilter = 0;

		long double b_fr1 = fvarg16;
		long double b_fr2 = fvarg17;
		long double b_fr3 = fvarg18;

		long double b_ffr[3];
		b_ffr[0] = b_fr1;
		b_ffr[1] = b_fr2;
		b_ffr[2] = b_fr3;

		if (b_flcmp1 != b_fr1) {b_flcmp1 = b_fr1; i_createfilter = 1;}
		if (b_flcmp2 != b_fr2) {b_flcmp2 = b_fr2; i_createfilter = 1;}
		if (b_flcmp3 != b_fr3) {b_flcmp3 = b_fr3; i_createfilter = 1;}



		if (i_createfilter == 1) {

			i_b = 0;
			while (i_b < 4) {
				i_cnt = 0;
				while (i_cnt < 30000) {
					b_unopcoff[i_b][i_cnt] = 0;
					i_cnt++;
				}
				i_b++;
			}

			i_b = 0;
			while (i_b < 4) {
				b_unopcoff[i_b][10000] = 1;
				i_b++;
			}

		int i_order = 0;
		while (i_order < 7) {

			// lowpasses
			double b_iir;
			i_b = 0;
			while (i_b < 3) {
				b_iir = 0;
				i_cnt = 0;
				while (i_cnt < 30000) {
					b_iir = b_iir + ((-b_iir + b_unopcoff[i_b][i_cnt]) * b_ffr[i_b]);
					b_unopcoff[i_b][i_cnt] = b_iir;
					i_cnt++;
				}
				i_b++;
			}

			i_b = 0;
			while (i_b < 3) {
				b_iir = 0;
				i_cnt = 29999;
				while (i_cnt > -1) {
					b_iir = b_iir + ((-b_iir + b_unopcoff[i_b][i_cnt]) * b_ffr[i_b]);
					b_unopcoff[i_b][i_cnt] = b_iir;
					i_cnt--;
				}
				i_b++;
			}

			i_order++;
		}


			double b_tmcoff[4][30000];
			i_b = 0;
			while (i_b < 4) {
				i_cnt = 0;
				while (i_cnt < 30000) {
					b_tmcoff[i_b][i_cnt] = b_unopcoff[i_b][i_cnt];
					i_cnt++;
				}
				i_b++;
			}

			// highpasses
			i_b = 1;
			while (i_b < 4) {
				i_cnt = 0;
				while (i_cnt < 30000) {
					int i_b2 = i_b - 1;
					b_unopcoff[i_b][i_cnt] = b_unopcoff[i_b][i_cnt] - b_tmcoff[i_b2][i_cnt];
					i_cnt++;
				}
				i_b++;
			}

		// slice mid
			i_b = 0;
			while (i_b < 4) {
				i_cnt = 0;
				while (i_cnt < 300) {
					int i_slice = i_cnt + 10000 - 150;
					b_unopcoff[i_b][i_cnt] = b_unopcoff[i_b][i_slice];
					i_cnt++;
				}
				i_b++;
			}

		}// end create filter

		

  for (lSampleIndex = 0; lSampleIndex < SampleCount; lSampleIndex++)
 {
   double b_in1 = *(pfInput1++);
   double b_in2 = *(pfInput2++);

///////////////////////////////////////////////////////////////////////////	
		// Input Gain / Threshold
///////////////////////////////////////////////////////////////////////////
		//multiband version
		long double b_in1c = b_in1;
		long double b_in2c = b_in2;
		b_in1 = 0;
		b_in2 = 0;
		long double b_in1b[4];
		long double b_in2b[4];

	i_b = 0;
	while (i_b < 4) {
		
		int i_syncread = i_bfcn - i_la[i_b]; 
		if (i_syncread < 0) {i_syncread = 1002 + i_syncread;}

		long double b_in1x = b_in1c;
		long double b_in2x = b_in2c;

		b_in1x = b_in1x * b_ingain[i_b];
		b_in2x = b_in2x * b_ingain[i_b];

		b_in1x = b_in1x * b_thr[i_b];
		b_in2x = b_in2x * b_thr[i_b];


///////// filter for multiband processing. / (gaussian - linearphase) / unoptimized direct convolution.

			long double b_unop1 = 0;
			long double b_unop2 = 0;
			b_unop1buf[i_b][i_bfcn] = b_in1x; 
			b_unop2buf[i_b][i_bfcn] = b_in2x; 
			i_cnt = 0;
			while (i_cnt < i_flen) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_unop1 = b_unop1 + (b_unop1buf[i_b][i_bufpoint] * b_unopcoff[i_b][i_cnt]);
				b_unop2 = b_unop2 + (b_unop2buf[i_b][i_bufpoint] * b_unopcoff[i_b][i_cnt]);
				i_cnt++;
			}

			b_in1x = b_unop1;
			b_in2x = b_unop2;



////////////////////////////////////////////////////////////////////////////////////////////
		// Rectification and SH for envelope and detector.
		long double b_inr = b_in1x; if (b_inr < 0) {b_inr = -b_inr;}
		long double b_inr2 = b_in2x; if (b_inr2 < 0) {b_inr2 = -b_inr2;}
		if (b_inr2 > b_inr) {b_inr = b_inr2;}

		if (b_inr < b_sensitivity) {b_inr = b_sensitivity;} // sensitivity and zero removal..

		//
		long double b_inrsh = b_inr;
		b_h1buf[i_b][i_bfcn] = b_inrsh;
		if (b_h1highest[i_b] < b_inrsh) {
			i_h1sortcurr[i_b] = 0;
			b_h1highest[i_b] = b_inrsh;
		}
		else if (i_h1sortcurr[i_b] > i_htravlensub[i_b]) {
			int cnt = 0;
			b_h1highest[i_b] = 0;
			while (cnt < i_htravlen[i_b]) {
				int i_bufpoint = i_bfcn - cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				if (b_h1highest[i_b] < b_h1buf[i_b][i_bufpoint]) {
					b_h1highest[i_b] = b_h1buf[i_b][i_bufpoint];
					i_h1sortcurr[i_b] = cnt;
				}
				cnt++;
			}
		}
		i_h1sortcurr[i_b]++;
		if (i_h1sortcurr[i_b] > 1002) {i_h1sortcurr[i_b] = 1002;}
		b_inrsh = b_h1highest[i_b];
		long double b_inrsync = b_h1buf[i_b][i_syncread];

/////////////////////////////////////////////////////////////////////////////

		long double b_rms = b_inr;
		b_rms = b_rms*b_rms;
		long double b_f5 = b_rms;

		b_avg5buf[i_b][i_bfcn] = b_f5; //

		i_bufpoint = i_bfcn - i_avglen2[i_b];
		if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}

		b_sub = b_avg5buf[i_b][i_bufpoint];
		b_tg21[i_b] = b_tg21[i_b] + b_f5 - b_sub;

		if (i_optcnt[i_b] == i_optimize) {
			b_tg21n[i_b] = i_avglen2[i_b];
			b_tg21n[i_b] = 1/b_tg21n[i_b];
		// make filter correct with regards to previous values
			i_cnt = 0;
			b_tg21[i_b] = 0;
			while (i_cnt < i_avglen2[i_b]) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg21[i_b] = b_tg21[i_b] + b_avg5buf[i_b][i_bufpoint];
				i_cnt++;
			}

		}
		b_f5 = b_tg21[i_b] * b_tg21n[i_b];
		b_rms = sqrt(b_f5);
		if (b_rms < 0) {b_rms = 0;}

		// fixed kneed SH attack, for less noise.
		b_lenv[i_b] = b_inr / b_lenv[i_b];
		long double b_knee = b_inr; if (b_knee > 1) {b_knee = 1;}
		if (b_knee < b_lenv[i_b]) {b_lenv[i_b] = b_knee;}
		b_lenv[i_b] = b_inr / b_lenv[i_b];

		b_h2buf[i_b][i_bfcn] = b_lenv[i_b];
		if (b_h2highest[i_b] < b_lenv[i_b]) {
			i_h2sortcurr[i_b] = 0;
			b_h2highest[i_b] = b_lenv[i_b];
		}
		else if (i_h2sortcurr[i_b] > i_htravlensub[i_b]) {
			int cnt = 0;
			b_h2highest[i_b] = 0;
			while (cnt < i_htravlen[i_b]) {
				int i_bufpoint = i_bfcn - cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				if (b_h2highest[i_b] < b_h2buf[i_b][i_bufpoint]) {
					b_h2highest[i_b] = b_h2buf[i_b][i_bufpoint];
					i_h2sortcurr[i_b] = cnt;
				}
				cnt++;
			}
		}
		i_h2sortcurr[i_b]++;
		if (i_h2sortcurr[i_b] > 1002) {i_h2sortcurr[i_b] = 1002;}
		b_lenv[i_b] = b_h2highest[i_b];

		b_syncbufL[i_b][i_bfcn] = b_in1x;
		b_syncbufR[i_b][i_bfcn] = b_in2x;
		b_in1x = b_syncbufL[i_b][i_syncread];
		b_in2x = b_syncbufR[i_b][i_syncread];

//////////////////////////////////
		// SH filter, pushed to the max.
		long double b_lenvf = b_lenv[i_b];
		long double b_inrshf = b_inrsh;

		// optimal minimal noise "pseudo-bandpass" filter
		b_f1 = 1/b_lenvf;
		b_f1 = sqrt(b_f1);
		b_f2 = b_f1 / b_lenvf;
		
		b_f3 = 1/b_inrshf;
		b_f3 = sqrt(b_f3);
		b_f4 = b_f3 / b_inrshf;
		
		b_avg1buf[i_b][i_bfcn] = b_f1;
		b_avg2buf[i_b][i_bfcn] = b_f2;
		b_avg3buf[i_b][i_bfcn] = b_f3;
		b_avg4buf[i_b][i_bfcn] = b_f4;

		i_bufpoint = i_bfcn - i_avglen[i_b];
		if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}

		b_sub = b_avg1buf[i_b][i_bufpoint];

		b_tg1[i_b] = b_tg1[i_b] - (b_sub * b_at1[i_b]);
		b_tg1[i_b] = b_tg1[i_b] + ((-b_tg1[i_b] + b_f1) * b_tgcut1[i_b]);

		b_tg2[i_b] = b_tg2[i_b] - (b_sub * b_at2[i_b]);
		b_tg2[i_b] = b_tg2[i_b] + ((-b_tg2[i_b] + b_f1) * b_tgcut2[i_b]);

		b_tg3[i_b] = b_tg3[i_b] - (b_sub * b_at3[i_b]);
		b_tg3[i_b] = b_tg3[i_b] + ((-b_tg3[i_b] + b_f1) * b_tgcut3[i_b]);

		b_tg4[i_b] = b_tg4[i_b] - (b_sub * b_at4[i_b]);
		b_tg4[i_b] = b_tg4[i_b] + ((-b_tg4[i_b] + b_f1) * b_tgcut4[i_b]);

		b_tg5[i_b] = b_tg5[i_b] - (b_sub * b_at5[i_b]);
		b_tg5[i_b] = b_tg5[i_b] + ((-b_tg5[i_b] + b_f1) * b_tgcut5[i_b]);

		b_sub = b_avg2buf[i_b][i_bufpoint];

		b_tg6[i_b] = b_tg6[i_b] - (b_sub * b_at1[i_b]);
		b_tg6[i_b] = b_tg6[i_b] + ((-b_tg6[i_b] + b_f2) * b_tgcut1[i_b]);

		b_tg7[i_b] = b_tg7[i_b] - (b_sub * b_at2[i_b]);
		b_tg7[i_b] = b_tg7[i_b] + ((-b_tg7[i_b] + b_f2) * b_tgcut2[i_b]);

		b_tg8[i_b] = b_tg8[i_b] - (b_sub * b_at3[i_b]);
		b_tg8[i_b] = b_tg8[i_b] + ((-b_tg8[i_b] + b_f2) * b_tgcut3[i_b]);

		b_tg9[i_b] = b_tg9[i_b] - (b_sub * b_at4[i_b]);
		b_tg9[i_b] = b_tg9[i_b] + ((-b_tg9[i_b] + b_f2) * b_tgcut4[i_b]);

		b_tg10[i_b] = b_tg10[i_b] - (b_sub * b_at5[i_b]);
		b_tg10[i_b] = b_tg10[i_b] + ((-b_tg10[i_b] + b_f2) * b_tgcut5[i_b]);

		b_sub = b_avg3buf[i_b][i_bufpoint];

		b_tg11[i_b] = b_tg11[i_b] - (b_sub * b_at1[i_b]);
		b_tg11[i_b] = b_tg11[i_b] + ((-b_tg11[i_b]+ b_f3) * b_tgcut1[i_b]);

		b_tg12[i_b] = b_tg12[i_b] - (b_sub * b_at2[i_b]);
		b_tg12[i_b] = b_tg12[i_b] + ((-b_tg12[i_b]+ b_f3) * b_tgcut2[i_b]);

		b_tg13[i_b] = b_tg13[i_b] - (b_sub * b_at3[i_b]);
		b_tg13[i_b] = b_tg13[i_b] + ((-b_tg13[i_b]+ b_f3) * b_tgcut3[i_b]);

		b_tg14[i_b] = b_tg14[i_b] - (b_sub * b_at4[i_b]);
		b_tg14[i_b] = b_tg14[i_b] + ((-b_tg14[i_b]+ b_f3) * b_tgcut4[i_b]);

		b_tg15[i_b] = b_tg15[i_b] - (b_sub * b_at5[i_b]);
		b_tg15[i_b] = b_tg15[i_b] + ((-b_tg15[i_b] + b_f3) * b_tgcut5[i_b]);

		b_sub = b_avg4buf[i_b][i_bufpoint];

		b_tg16[i_b]= b_tg16[i_b] - (b_sub * b_at1[i_b]);
		b_tg16[i_b]= b_tg16[i_b] + ((-b_tg16[i_b]+ b_f4) * b_tgcut1[i_b]);

		b_tg17[i_b]= b_tg17[i_b] - (b_sub * b_at2[i_b]);
		b_tg17[i_b]= b_tg17[i_b] + ((-b_tg17[i_b]+ b_f4) * b_tgcut2[i_b]);

		b_tg18[i_b]= b_tg18[i_b] - (b_sub * b_at3[i_b]);
		b_tg18[i_b]= b_tg18[i_b] + ((-b_tg18[i_b]+ b_f4) * b_tgcut3[i_b]);

		b_tg19[i_b]= b_tg19[i_b] - (b_sub * b_at4[i_b]);
		b_tg19[i_b]= b_tg19[i_b] + ((-b_tg19[i_b]+ b_f4) * b_tgcut4[i_b]);

		b_tg20[i_b] = b_tg20[i_b] - (b_sub * b_at5[i_b]);
		b_tg20[i_b] = b_tg20[i_b] + ((-b_tg20[i_b] + b_f4) * b_tgcut5[i_b]);


		if (i_optcnt[i_b] == i_optimize) {
			long double b_one;
			// find at
			i_cnt = 0;
			b_nr1[i_b] = 0;
			b_at1[i_b] = 0;
			while (i_cnt < i_avglen[i_b]) {
				if (i_cnt == 0) {b_at1[i_b] = b_at1[i_b] + ((-b_at1[i_b] + 1) * b_tgcut1[i_b]);} else {b_at1[i_b] = b_at1[i_b] + ((-b_at1[i_b] + 0) * b_tgcut1[i_b]);}
				b_nr1[i_b] = b_nr1[i_b] + ((-b_nr1[i_b] + 1) * b_tgcut1[i_b]);
				i_cnt++;
			}

		// make filter correct with regards to previous values
			i_cnt = i_avglen[i_b]-1;
			b_tg1[i_b] = 0;
			b_tg6[i_b] = 0;
			b_tg11[i_b] = 0;
			b_tg16[i_b] = 0;
			while (i_cnt > -1) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg1[i_b] = b_tg1[i_b] + ((-b_tg1[i_b] + b_avg1buf[i_b][i_bufpoint]) * b_tgcut1[i_b]);
				b_tg6[i_b] = b_tg6[i_b] + ((-b_tg6[i_b] + b_avg2buf[i_b][i_bufpoint]) * b_tgcut1[i_b]);
				b_tg11[i_b]= b_tg11[i_b]+ ((-b_tg11[i_b]+ b_avg3buf[i_b][i_bufpoint]) * b_tgcut1[i_b]);
				b_tg16[i_b]= b_tg16[i_b]+ ((-b_tg16[i_b]+ b_avg4buf[i_b][i_bufpoint]) * b_tgcut1[i_b]);
				i_cnt--;
			}

		// find at
			i_cnt = 0;
			b_nr2[i_b] = 0;
			b_at2[i_b] = 0;
			while (i_cnt < i_avglen[i_b]) {
				if (i_cnt == 0) {b_at2[i_b] = b_at2[i_b] + ((-b_at2[i_b] + 1) * b_tgcut2[i_b]);} else {b_at2[i_b] = b_at2[i_b] + ((-b_at2[i_b] + 0) * b_tgcut2[i_b]);}
				b_nr2[i_b] = b_nr2[i_b] + ((-b_nr2[i_b] + 1) * b_tgcut2[i_b]);
				i_cnt++;
			}

		// make filter correct with regards to previous values
			i_cnt = i_avglen[i_b]-1;
			b_tg2[i_b] = 0;
			b_tg7[i_b] = 0;
			b_tg12[i_b] = 0;
			b_tg17[i_b] = 0;
			while (i_cnt > -1) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg2[i_b] = b_tg2[i_b] + ((-b_tg2[i_b] + b_avg1buf[i_b][i_bufpoint]) * b_tgcut2[i_b]);
				b_tg7[i_b] = b_tg7[i_b] + ((-b_tg7[i_b] + b_avg2buf[i_b][i_bufpoint]) * b_tgcut2[i_b]);
				b_tg12[i_b]= b_tg12[i_b]+ ((-b_tg12[i_b]+ b_avg3buf[i_b][i_bufpoint]) * b_tgcut2[i_b]);
				b_tg17[i_b]= b_tg17[i_b]+ ((-b_tg17[i_b]+ b_avg4buf[i_b][i_bufpoint]) * b_tgcut2[i_b]);
				i_cnt--;
			}

		// find at
			i_cnt = 0;
			b_nr3[i_b] = 0;
			b_at3[i_b] = 0;
			while (i_cnt < i_avglen[i_b]) {
				if (i_cnt == 0) {b_at3[i_b] = b_at3[i_b] + ((-b_at3[i_b] + 1) * b_tgcut3[i_b]);} else {b_at3[i_b] = b_at3[i_b] + ((-b_at3[i_b] + 0) * b_tgcut3[i_b]);}
				b_nr3[i_b] = b_nr3[i_b] + ((-b_nr3[i_b] + 1) * b_tgcut3[i_b]);
				i_cnt++;
			}

		// make filter correct with regards to previous values
			i_cnt = i_avglen[i_b]-1;
			b_tg3[i_b] = 0;
			b_tg8[i_b] = 0;
			b_tg13[i_b] = 0;
			b_tg18[i_b] = 0;
			while (i_cnt > -1) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg3[i_b] = b_tg3[i_b] + ((-b_tg3[i_b] + b_avg1buf[i_b][i_bufpoint]) * b_tgcut3[i_b]);
				b_tg8[i_b] = b_tg8[i_b] + ((-b_tg8[i_b] + b_avg2buf[i_b][i_bufpoint]) * b_tgcut3[i_b]);
				b_tg13[i_b]= b_tg13[i_b]+ ((-b_tg13[i_b]+ b_avg3buf[i_b][i_bufpoint]) * b_tgcut3[i_b]);
				b_tg18[i_b]= b_tg18[i_b]+ ((-b_tg18[i_b]+ b_avg4buf[i_b][i_bufpoint]) * b_tgcut3[i_b]);
				i_cnt--;
			}

		// find at
			i_cnt = 0;
			b_nr4[i_b] = 0;
			b_at4[i_b] = 0;
			while (i_cnt < i_avglen[i_b]) {
				if (i_cnt == 0) {b_at4[i_b] = b_at4[i_b] + ((-b_at4[i_b] + 1) * b_tgcut4[i_b]);} else {b_at4[i_b] = b_at4[i_b] + ((-b_at4[i_b] + 0) * b_tgcut4[i_b]);}
				b_nr4[i_b] = b_nr4[i_b] + ((-b_nr4[i_b] + 1) * b_tgcut4[i_b]);
				i_cnt++;
			}

		// make filter correct with regards to previous values
			i_cnt = i_avglen[i_b]-1;
			b_tg4[i_b] = 0;
			b_tg9[i_b] = 0;
			b_tg14[i_b] = 0;
			b_tg19[i_b] = 0;
			while (i_cnt > -1) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg4[i_b] = b_tg4[i_b] + ((-b_tg4[i_b] + b_avg1buf[i_b][i_bufpoint]) * b_tgcut4[i_b]);
				b_tg9[i_b] = b_tg9[i_b] + ((-b_tg9[i_b] + b_avg2buf[i_b][i_bufpoint]) * b_tgcut4[i_b]);
				b_tg14[i_b]= b_tg14[i_b]+ ((-b_tg14[i_b]+ b_avg3buf[i_b][i_bufpoint]) * b_tgcut4[i_b]);
				b_tg19[i_b]= b_tg19[i_b]+ ((-b_tg19[i_b]+ b_avg4buf[i_b][i_bufpoint]) * b_tgcut4[i_b]);
				i_cnt--;
			}

		// find at
			i_cnt = 0;
			b_nr5[i_b] = 0;
			b_at5[i_b] = 0;
			while (i_cnt < i_avglen[i_b]) {
				if (i_cnt == 0) {b_at5[i_b] = b_at5[i_b] + ((-b_at5[i_b] + 1) * b_tgcut5[i_b]);} else {b_at5[i_b] = b_at5[i_b] + ((-b_at5[i_b] + 0) * b_tgcut5[i_b]);}
				b_nr5[i_b] = b_nr5[i_b] + ((-b_nr5[i_b] + 1) * b_tgcut5[i_b]);
				i_cnt++;
			}

		// make filter correct with regards to previous values
			i_cnt = i_avglen[i_b]-1;
			b_tg5[i_b] = 0;
			b_tg10[i_b] = 0;
			b_tg15[i_b] = 0;
			b_tg20[i_b] = 0;
			b_one = b_tgcut5[i_b];
			while (i_cnt > -1) {
				i_bufpoint = i_bfcn - i_cnt;
				if (i_bufpoint < 0) {i_bufpoint = 1002 + i_bufpoint;}
				b_tg5[i_b] = b_tg5[i_b] + ((-b_tg5[i_b] + b_avg1buf[i_b][i_bufpoint]) * b_tgcut5[i_b]);
				b_tg10[i_b]= b_tg10[i_b]+ ((-b_tg10[i_b]+ b_avg2buf[i_b][i_bufpoint]) * b_tgcut5[i_b]);
				b_tg15[i_b]= b_tg15[i_b]+ ((-b_tg15[i_b]+ b_avg3buf[i_b][i_bufpoint]) * b_tgcut5[i_b]);
				b_tg20[i_b]= b_tg20[i_b]+ ((-b_tg20[i_b]+ b_avg4buf[i_b][i_bufpoint]) * b_tgcut5[i_b]);
				i_cnt--;
			}
		}

//////// Kahan summing, for the extreme offsetted data.
		b_of1 = b_tggain1[i_b] * b_tg1[i_b];
		b_of2 = b_tggain2[i_b] * b_tg2[i_b];
		b_of3 = b_tggain3[i_b] * b_tg3[i_b];
		b_of4 = b_tggain4[i_b] * b_tg4[i_b];
		b_of5 = b_tggain5[i_b] * b_tg5[i_b];
		
		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_f1 = b_cSum;
///////////////////////////////////////////

		b_of1 = b_tggain1[i_b] * b_tg6[i_b];
		b_of2 = b_tggain2[i_b] * b_tg7[i_b];
		b_of3 = b_tggain3[i_b] * b_tg8[i_b];
		b_of4 = b_tggain4[i_b] * b_tg9[i_b];
		b_of5 = b_tggain5[i_b] * b_tg10[i_b];

		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_f2 = b_cSum;
///////////////////////////////////////////

		b_of1 = b_tggain1[i_b] * b_tg11[i_b];
		b_of2 = b_tggain2[i_b] * b_tg12[i_b];
		b_of3 = b_tggain3[i_b] * b_tg13[i_b];
		b_of4 = b_tggain4[i_b] * b_tg14[i_b];
		b_of5 = b_tggain5[i_b] * b_tg15[i_b];

		b_cErr = 0;
		b_cSum = 0;
	
		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_f3 = b_cSum;
///////////////////////////////////////////

		b_of1 = b_tggain1[i_b] * b_tg16[i_b];
		b_of2 = b_tggain2[i_b] * b_tg17[i_b];
		b_of3 = b_tggain3[i_b] * b_tg18[i_b];
		b_of4 = b_tggain4[i_b] * b_tg19[i_b];
		b_of5 = b_tggain5[i_b] * b_tg20[i_b];

		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_f4 = b_cSum;
///////////////////////////////////////////

		b_of1 = b_tggain1[i_b] * b_nr1[i_b];
		b_of2 = b_tggain2[i_b] * b_nr2[i_b];
		b_of3 = b_tggain3[i_b] * b_nr3[i_b];
		b_of4 = b_tggain4[i_b] * b_nr4[i_b];
		b_of5 = b_tggain5[i_b] * b_nr5[i_b];

		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		long double b_fn = b_cSum;
	
		b_f1 = b_f1 / b_fn;
		b_f2 = b_f2 / b_fn;
		b_f3 = b_f3 / b_fn;
		b_f4 = b_f4 / b_fn;


////////
// small window for discontinuities
		int i_discread = i_bfcn - i_la[i_b];
		if (i_discread < 0) {i_discread = 1002 + i_discread;}

	long double b_disc1 = b_avg1buf[i_b][i_syncread];
	long double b_disc2 = b_avg2buf[i_b][i_syncread];
	long double b_disc3 = b_avg3buf[i_b][i_syncread];
	long double b_disc4 = b_avg4buf[i_b][i_syncread];


	b_f1 = b_f1 + ((-b_f1 + b_disc1) * b_discam);
	b_f2 = b_f2 + ((-b_f2 + b_disc2) * b_discam);
	b_f3 = b_f3 + ((-b_f3 + b_disc3) * b_discam);
	b_f4 = b_f4 + ((-b_f4 + b_disc4) * b_discam);

////////////////////////////////////////////////////////////////////////////////////////
		b_lenvf = (b_f1 / b_f2);
		b_inrshf = (b_f3 / b_f4);

		// Do limiting.
		b_in1x = b_in1x / b_lenvf;
		b_in2x = b_in2x / b_lenvf;

////////////////////////////////////////////////////////////////////////////////////////
//////////////Release Stage

		// Gaussian Env Smoother / Denoiser / Saturated Attack "ubkgauss59"
		b_lenv[i_b] = b_lenv[i_b]*b_lenv[i_b]; // rms

		b_gse1buf[i_b] = b_gse1buf[i_b] + ((-b_gse1buf[i_b] + b_lenv[i_b]) * b_gse1cut); // onepoles.
		b_gse2buf[i_b] = b_gse2buf[i_b] + ((-b_gse2buf[i_b] + b_lenv[i_b]) * b_gse2cut);
		b_gse3buf[i_b] = b_gse3buf[i_b] + ((-b_gse3buf[i_b] + b_lenv[i_b]) * b_gse3cut);
		b_gse4buf[i_b] = b_gse4buf[i_b] + ((-b_gse4buf[i_b] + b_lenv[i_b]) * b_gse4cut);
		b_gse5buf[i_b] = b_gse5buf[i_b] + ((-b_gse5buf[i_b] + b_lenv[i_b]) * b_gse5cut);

		//Ksum
		b_of1 = b_gse1gain * b_gse1buf[i_b];
		b_of2 = b_gse2gain * b_gse2buf[i_b];
		b_of3 = b_gse3gain * b_gse3buf[i_b];
		b_of4 = b_gse4gain * b_gse4buf[i_b];
		b_of5 = b_gse5gain * b_gse5buf[i_b];

		b_cErr = 0;
		b_cSum = 0;

		b_cIn = b_of1;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_cIn = b_of2;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of3;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of4;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;

		b_cIn = b_of5;
		b_cSub = b_cIn - b_cErr; b_cSumpre = b_cSum;
		b_cSum = b_cSum + b_cSub;
		b_cErr = (b_cSum-b_cSumpre) - b_cSub;
		
		b_lenv[i_b] = b_cSum;
		


		b_lenv[i_b] = sqrt(b_lenv[i_b]);

		// release
//		b_rms = b_inrshf + ((-b_inrshf + b_rms) * b_rtype); // mix a little for psychoacoustic improvement. - not implemented.
		long double b_deenv = b_rms;

		long double b_lenvdet = b_inrsync / b_lenv[i_b];
		long double b_deenvdet = b_inrsync / b_deenv;
		b_lenvdet = b_lenvdet + (b_deenvdet * b_release[i_b]); // release, in-phase.

		b_lenv[i_b] = b_inrsync / b_lenvdet;

		// releaselimit
		if (b_lenv[i_b] < b_inrshf) {b_lenv[i_b] = b_inrshf;} // not over filtered version.

////////////////////////////////////////////////////////////////////////////////////////////////

		b_in1x = b_in1x / b_thr[i_b];
		b_in2x = b_in2x / b_thr[i_b];

////////////////////////////////////////////////////////////////////////////////////////////////

//		b_in1 = b_in1x;
//		b_in2 = b_in2x;


		int i_syncread2 = i_bfcn - (i_highla - i_la[i_b]); 
		if (i_syncread2 < 0) {i_syncread2 = 1002 + i_syncread2;}

		b_syncbufL2[i_b][i_bfcn] = b_in1x;
		b_syncbufR2[i_b][i_bfcn] = b_in2x;
		b_in1x = b_syncbufL2[i_b][i_syncread2];
		b_in2x = b_syncbufR2[i_b][i_syncread2];

		b_in1 = b_in1 + b_in1x;
		b_in2 = b_in2 + b_in2x;

		b_in1b[i_b] = b_in1x;
		b_in2b[i_b] = b_in2x;

		if (i_solo > 0) {
			b_in1 = b_in1b[i_solo-1];
			b_in2 = b_in2b[i_solo-1];
		}
		
		if (i_optcnt[i_b] == i_optimize) {i_optcnt[i_b] = 0;}
		i_b++;
	}




   *(pfOutput1++) = b_in1;
   *(pfOutput2++) = b_in2;
 }


}

/*****************************************************************************/

/* Throw away a simple delay line. */
void
cleanupPxu(LADSPA_Handle Instance) {
  free(Instance);
}

/*****************************************************************************/

LADSPA_Descriptor * g_psMonoDescriptor = NULL;
LADSPA_Descriptor * g_psStereoDescriptor = NULL;

/*****************************************************************************/

/* _init() is called automatically when the plugin library is first
   loaded. */
void
_init() {

  char ** pcPortNames;
  LADSPA_PortDescriptor * piPortDescriptors;
  LADSPA_PortRangeHint * psPortRangeHints;

  g_psMonoDescriptor
    = (LADSPA_Descriptor *)malloc(sizeof(LADSPA_Descriptor));
  g_psStereoDescriptor
    = (LADSPA_Descriptor *)malloc(sizeof(LADSPA_Descriptor));

  if (g_psMonoDescriptor) {

    g_psMonoDescriptor->UniqueID
      = 990;
    g_psMonoDescriptor->Label
      = strdup("Mlm_Limiter_4-way_M");
    g_psMonoDescriptor->Properties
      = LADSPA_PROPERTY_HARD_RT_CAPABLE;
    g_psMonoDescriptor->Name
      = strdup("Millennium Limiter 4-way [mono] (not implemented)");
    g_psMonoDescriptor->Maker
      = strdup("Opensource GPL");
    g_psMonoDescriptor->Copyright
      = strdup("Opensource GPL");
    g_psMonoDescriptor->PortCount
      = 22;
    piPortDescriptors
      = (LADSPA_PortDescriptor *)calloc(22, sizeof(LADSPA_PortDescriptor));
    g_psMonoDescriptor->PortDescriptors
      = (const LADSPA_PortDescriptor *)piPortDescriptors;
    piPortDescriptors[PXU_CONTROL1] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL2] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL3] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL4] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL5] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL6] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL7] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL8] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL9] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL10] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL11] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL12] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL13] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL14] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL15] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL16] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL17] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL18] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL19] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL20] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_INPUT1]
      = LADSPA_PORT_INPUT | LADSPA_PORT_AUDIO;
    piPortDescriptors[PXU_OUTPUT1]
      = LADSPA_PORT_OUTPUT | LADSPA_PORT_AUDIO;
    pcPortNames
      = (char **)calloc(22, sizeof(char *));
    g_psMonoDescriptor->PortNames
      = (const char **)pcPortNames;
    pcPortNames[PXU_CONTROL1] = strdup("1.Gain");
    pcPortNames[PXU_CONTROL2] = strdup("1.Thresh");
    pcPortNames[PXU_CONTROL3] = strdup("1.Buffer");
    pcPortNames[PXU_CONTROL4] = strdup("1.Release");
    pcPortNames[PXU_CONTROL5] = strdup("2.Gain");
    pcPortNames[PXU_CONTROL6] = strdup("2.Thresh");
    pcPortNames[PXU_CONTROL7] = strdup("2.Buffer");
    pcPortNames[PXU_CONTROL8] = strdup("2.Release");
    pcPortNames[PXU_CONTROL9] = strdup("3.Gain");
    pcPortNames[PXU_CONTROL10] = strdup("3.Thresh");
    pcPortNames[PXU_CONTROL11] = strdup("3.Buffer");
    pcPortNames[PXU_CONTROL12] = strdup("3.Release");
    pcPortNames[PXU_CONTROL13] = strdup("4.Gain");
    pcPortNames[PXU_CONTROL14] = strdup("4.Thresh");
    pcPortNames[PXU_CONTROL15] = strdup("4.Buffer");
    pcPortNames[PXU_CONTROL16] = strdup("4.Release");
    pcPortNames[PXU_CONTROL17] = strdup("Freq1");
    pcPortNames[PXU_CONTROL18] = strdup("Freq2");
    pcPortNames[PXU_CONTROL19] = strdup("Freq3");
    pcPortNames[PXU_CONTROL20] = strdup("Solo");
    pcPortNames[PXU_INPUT1]
      = strdup("Input");
    pcPortNames[PXU_OUTPUT1]
      = strdup("Output");
    psPortRangeHints = ((LADSPA_PortRangeHint *)
			calloc(22, sizeof(LADSPA_PortRangeHint)));
    g_psMonoDescriptor->PortRangeHints
      = (const LADSPA_PortRangeHint *)psPortRangeHints;
    pcPortNames[PXU_CONTROL1] = strdup("1.Gain");
    pcPortNames[PXU_CONTROL2] = strdup("1.Thresh");
    pcPortNames[PXU_CONTROL3] = strdup("1.Buffer");
    pcPortNames[PXU_CONTROL4] = strdup("1.Release");
    pcPortNames[PXU_CONTROL5] = strdup("2.Gain");
    pcPortNames[PXU_CONTROL6] = strdup("2.Thresh");
    pcPortNames[PXU_CONTROL7] = strdup("2.Buffer");
    pcPortNames[PXU_CONTROL8] = strdup("2.Release");
    pcPortNames[PXU_CONTROL9] = strdup("3.Gain");
    pcPortNames[PXU_CONTROL10] = strdup("3.Thresh");
    pcPortNames[PXU_CONTROL11] = strdup("3.Buffer");
    pcPortNames[PXU_CONTROL12] = strdup("3.Release");
    pcPortNames[PXU_CONTROL13] = strdup("4.Gain");
    pcPortNames[PXU_CONTROL14] = strdup("4.Thresh");
    pcPortNames[PXU_CONTROL15] = strdup("4.Buffer");
    pcPortNames[PXU_CONTROL16] = strdup("4.Release");
    pcPortNames[PXU_CONTROL17] = strdup("Freq1");
    pcPortNames[PXU_CONTROL18] = strdup("Freq2");
    pcPortNames[PXU_CONTROL19] = strdup("Freq3");
    pcPortNames[PXU_CONTROL20] = strdup("Solo");
    pcPortNames[PXU_INPUT1]  = strdup("Input (Left)");
    pcPortNames[PXU_OUTPUT1] = strdup("Output (Left)");
    pcPortNames[PXU_INPUT2]  = strdup("Input (Right)");
    pcPortNames[PXU_OUTPUT2] = strdup("Output (Right)");
    psPortRangeHints[PXU_INPUT1].HintDescriptor
      = 0;
    psPortRangeHints[PXU_OUTPUT1].HintDescriptor
      = 0;
    g_psMonoDescriptor->instantiate
      = instantiatePxu;
    g_psMonoDescriptor->connect_port
      = connectPortToPxu;
    g_psMonoDescriptor->activate
      = NULL;
    g_psMonoDescriptor->run
      = runMonoPxu;
    g_psMonoDescriptor->run_adding
      = NULL;
    g_psMonoDescriptor->set_run_adding_gain
      = NULL;
    g_psMonoDescriptor->deactivate
      = NULL;
    g_psMonoDescriptor->cleanup
      = cleanupPxu;
  }

  if (g_psStereoDescriptor) {

    g_psStereoDescriptor->UniqueID
      = 991;
    g_psStereoDescriptor->Label
      = strdup("Mlm_Limiter_4-way_S");
    g_psStereoDescriptor->Properties
      = LADSPA_PROPERTY_HARD_RT_CAPABLE;
    g_psStereoDescriptor->Name
      = strdup("Millennium Limiter 4-way [stereo]");
    g_psStereoDescriptor->Maker
      = strdup("Opensource GPL)");
    g_psStereoDescriptor->Copyright
      = strdup("Opensource GPL");
    g_psStereoDescriptor->PortCount
      = 24;
    piPortDescriptors
      = (LADSPA_PortDescriptor *)calloc(24, sizeof(LADSPA_PortDescriptor));
    g_psStereoDescriptor->PortDescriptors
      = (const LADSPA_PortDescriptor *)piPortDescriptors;
    piPortDescriptors[PXU_CONTROL1] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL2] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL3] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL4] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL5] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL6] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL7] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL8] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL9] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL10] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL11] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL12] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL13] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL14] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL15] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL16] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL17] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL18] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL19] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_CONTROL20] = LADSPA_PORT_INPUT | LADSPA_PORT_CONTROL; 
    piPortDescriptors[PXU_INPUT1]
      = LADSPA_PORT_INPUT | LADSPA_PORT_AUDIO;
    piPortDescriptors[PXU_OUTPUT1]
      = LADSPA_PORT_OUTPUT | LADSPA_PORT_AUDIO;
    piPortDescriptors[PXU_INPUT2]
      = LADSPA_PORT_INPUT | LADSPA_PORT_AUDIO;
    piPortDescriptors[PXU_OUTPUT2]
      = LADSPA_PORT_OUTPUT | LADSPA_PORT_AUDIO;
    pcPortNames
      = (char **)calloc(24, sizeof(char *));
    g_psStereoDescriptor->PortNames
      = (const char **)pcPortNames;
    pcPortNames[PXU_CONTROL1] = strdup("1.Gain");
    pcPortNames[PXU_CONTROL2] = strdup("1.Thresh");
    pcPortNames[PXU_CONTROL3] = strdup("1.Buffer");
    pcPortNames[PXU_CONTROL4] = strdup("1.Release");
    pcPortNames[PXU_CONTROL5] = strdup("2.Gain");
    pcPortNames[PXU_CONTROL6] = strdup("2.Thresh");
    pcPortNames[PXU_CONTROL7] = strdup("2.Buffer");
    pcPortNames[PXU_CONTROL8] = strdup("2.Release");
    pcPortNames[PXU_CONTROL9] = strdup("3.Gain");
    pcPortNames[PXU_CONTROL10] = strdup("3.Thresh");
    pcPortNames[PXU_CONTROL11] = strdup("3.Buffer");
    pcPortNames[PXU_CONTROL12] = strdup("3.Release");
    pcPortNames[PXU_CONTROL13] = strdup("4.Gain");
    pcPortNames[PXU_CONTROL14] = strdup("4.Thresh");
    pcPortNames[PXU_CONTROL15] = strdup("4.Buffer");
    pcPortNames[PXU_CONTROL16] = strdup("4.Release");
    pcPortNames[PXU_CONTROL17] = strdup("Freq1");
    pcPortNames[PXU_CONTROL18] = strdup("Freq2");
    pcPortNames[PXU_CONTROL19] = strdup("Freq3");
    pcPortNames[PXU_CONTROL20] = strdup("Solo");
    pcPortNames[PXU_INPUT1]  = strdup("Input (Left)");
    pcPortNames[PXU_OUTPUT1] = strdup("Output (Left)");
    pcPortNames[PXU_INPUT2]  = strdup("Input (Right)");
    pcPortNames[PXU_OUTPUT2] = strdup("Output (Right)");
    psPortRangeHints = ((LADSPA_PortRangeHint *)
			calloc(24, sizeof(LADSPA_PortRangeHint)));
    g_psStereoDescriptor->PortRangeHints
      = (const LADSPA_PortRangeHint *)psPortRangeHints;

    	psPortRangeHints[PXU_CONTROL1].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL1].LowerBound = 0; psPortRangeHints[PXU_CONTROL1].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL2].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL2].LowerBound = 0; psPortRangeHints[PXU_CONTROL2].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL3].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL3].LowerBound = 0; psPortRangeHints[PXU_CONTROL3].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL4].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL4].LowerBound = 0; psPortRangeHints[PXU_CONTROL4].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL5].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL5].LowerBound = 0; psPortRangeHints[PXU_CONTROL5].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL6].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL6].LowerBound = 0; psPortRangeHints[PXU_CONTROL6].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL7].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL7].LowerBound = 0; psPortRangeHints[PXU_CONTROL7].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL8].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL8].LowerBound = 0; psPortRangeHints[PXU_CONTROL8].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL9].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL9].LowerBound = 0; psPortRangeHints[PXU_CONTROL9].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL10].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL10].LowerBound = 0; psPortRangeHints[PXU_CONTROL10].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL11].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL11].LowerBound = 0; psPortRangeHints[PXU_CONTROL11].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL12].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL12].LowerBound = 0; psPortRangeHints[PXU_CONTROL12].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL13].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL13].LowerBound = 0; psPortRangeHints[PXU_CONTROL13].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL14].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL14].LowerBound = 0; psPortRangeHints[PXU_CONTROL14].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL15].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL15].LowerBound = 0; psPortRangeHints[PXU_CONTROL15].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL16].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL16].LowerBound = 0; psPortRangeHints[PXU_CONTROL16].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL17].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL17].LowerBound = 0; psPortRangeHints[PXU_CONTROL17].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL18].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL18].LowerBound = 0; psPortRangeHints[PXU_CONTROL18].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL19].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL19].LowerBound = 0; psPortRangeHints[PXU_CONTROL19].UpperBound = 1;
    	psPortRangeHints[PXU_CONTROL20].HintDescriptor = (LADSPA_HINT_BOUNDED_BELOW | LADSPA_HINT_BOUNDED_ABOVE | LADSPA_HINT_DEFAULT_MIDDLE);
	psPortRangeHints[PXU_CONTROL20].LowerBound = 0; psPortRangeHints[PXU_CONTROL20].UpperBound = 1;


    psPortRangeHints[PXU_INPUT1].HintDescriptor
      = 0;
    psPortRangeHints[PXU_OUTPUT1].HintDescriptor
      = 0;
    psPortRangeHints[PXU_INPUT2].HintDescriptor
      = 0;
    psPortRangeHints[PXU_OUTPUT2].HintDescriptor
      = 0;
    g_psStereoDescriptor->instantiate
      = instantiatePxu;
    g_psStereoDescriptor->connect_port	
      = connectPortToPxu;
    g_psStereoDescriptor->activate
      = NULL;
    g_psStereoDescriptor->run
      = runStereoPxu;
    g_psStereoDescriptor->run_adding
      = NULL;
    g_psStereoDescriptor->set_run_adding_gain
      = NULL;
    g_psStereoDescriptor->deactivate
      = NULL;
    g_psStereoDescriptor->cleanup
      = cleanupPxu;
  }
}

/*****************************************************************************/

void
deleteDescriptor(LADSPA_Descriptor * psDescriptor) {
  unsigned long lIndex;
  if (psDescriptor) {
    free((char *)psDescriptor->Label);
    free((char *)psDescriptor->Name);
    free((char *)psDescriptor->Maker);
    free((char *)psDescriptor->Copyright);
    free((LADSPA_PortDescriptor *)psDescriptor->PortDescriptors);
    for (lIndex = 0; lIndex < psDescriptor->PortCount; lIndex++)
      free((char *)(psDescriptor->PortNames[lIndex]));
    free((char **)psDescriptor->PortNames);
    free((LADSPA_PortRangeHint *)psDescriptor->PortRangeHints);
    free(psDescriptor);
  }
}

/*****************************************************************************/

/* _fini() is called automatically when the library is unloaded. */
void
_fini() {
  deleteDescriptor(g_psMonoDescriptor);
  deleteDescriptor(g_psStereoDescriptor);
}

/*****************************************************************************/

/* Return a descriptor of the requested plugin type. There are two
   plugin types available in this library (mono and stereo). */
const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index) {
  /* Return the requested descriptor or null if the index is out of
     range. */
  switch (Index) {
  case 0:
    return g_psMonoDescriptor;
  case 1:
    return g_psStereoDescriptor;
  default:
    return NULL;
  }
}

/*****************************************************************************/

/* EOF */
